<?
// include le classi che implementano il protocollo
include_once("elastico_bridge.php");

// visualizza la form
function showForm() {
	echo '<form method="POST" name="console" enctype="multipart/form-data">';
	echo '<table class="console">';
	echo '<thead>';
	echo '<tr>';
	echo '<th colspan="2">Invia query a Elastico Bridge</th>';
	echo '</tr>';
	echo '</thead>';
	echo '<tr>';
	echo '<th>','<label for="srv_address">Indirizzo ip/porta:</label>','</th>';
	echo '<td>','<input type="text" name="srv_address" value="',($_REQUEST["posted"]?$_REQUEST["srv_address"]:$_SERVER["SERVER_ADDR"]),'" size="15" />','&nbsp;','<input type="text" name="srv_port" value="',($_REQUEST["posted"]?$_REQUEST["srv_port"]:'13570'),'" size="6" maxlength="5" />','</td>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>','<label for="cod_azi">Codice azienda:</label>','</th>';
	echo '<td>','<input type="text" name="cod_azi" value="',($_REQUEST["posted"]?$_REQUEST["cod_azi"]:'DM'),'" size="3" maxlength="2"/>','</td>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>','<label for="query_type">Tipo query:</label>','</th>';
	echo '<td>';
	echo '<select name="query_type">';
	echo '<option value="query"',($_REQUEST["query_type"]=="query" || !$_REQUEST["posted"] ? 'selected="selected"' : ''),'>BRIDGE_CMD_QUERY</option>';
	echo '<option value="execute"',($_REQUEST["query_type"]=="execute" ? 'selected="selected"' : ''),'>BRIDGE_CMD_EXECUTE</option>';
	echo '<option value="image"',($_REQUEST["query_type"]=="image" ? 'selected="selected"' : ''),'>BRIDGE_CMD_GET_IMAGE</option>';
	echo '<option value="attachment"',($_REQUEST["query_type"]=="attachment" ? 'selected="selected"' : ''),'>BRIDGE_CMD_GET_ATTACHMENT</option>';
	echo '<option value="server_info"',($_REQUEST["query_type"]=="server_info" ? 'selected="selected"' : ''),'>BRIDGE_CMD_SERVER_INFO</option>';
	echo '</select>';
	echo '</td>';
	echo '</tr>';
	echo '<tr>';
	echo '<th>','<label for="query_sql">Query SQL:</label>','</th>';
	echo '<td>','<textarea name="query_sql" rows="6" cols="80">',stripslashes($_REQUEST["query_sql"]),'</textarea>','</td>';
	echo '</tr>';
	echo '<tfoot>';
	echo '<tr>';
	echo '<th colspan="2" align="center">','<input type="submit" value="Esegui query"/>','</th>';
	echo '</tr>';
	echo '</tfoot>';
	echo '</table>';
	echo '<input type="hidden" name="posted" value="1" />';
   echo '</form>';
}

// invia il comando al server, qundi riceve e visualizza il risultato
function doRequest() {
	
	if(!$_REQUEST["srv_address"]) {
		echo '<div class="error">L\'indirizzo ip del server  obbligatorio</div>';
		return;		
	}

	if(!$_REQUEST["srv_port"]) {
		echo '<div class="error">La porta del server  obbligatoria</div>';
		return;		
	}

	if(!$_REQUEST["cod_azi"]) {
		echo '<div class="error">L\'azienda  obbligatoria</div>';
		return;		
	}
	
	$query_sql = stripslashes($_REQUEST["query_sql"]);
	if(strlen($query_sql)==0 && $_REQUEST["query_type"]!="server_info") {
		echo '<div class="error">La query  obbligatoria</div>';
		return;		
	}

	// apre la connessione con elastico bridge
	$conn = new ElasticoBridgeConnection($_REQUEST["srv_address"], $_REQUEST["srv_port"]);

	if ($conn->Connect()) {
		echo '<div class="command">BRIDGE_CMD_SETCURAZI</div>';
		if ($conn->SetCurrentAzi($_REQUEST["cod_azi"])) {
			echo '<div class="info">Azienda ',$_REQUEST["cod_azi"],' selezionata correttamente.</div>';
			
			if($_REQUEST["query_type"]=="image") {
				///////////////////////////////////////////////////////////////////
				// legge l'immagine
				///////////////////////////////////////////////////////////////////			
				echo '<div class="command">BRIDGE_CMD_GET_IMAGE</div>';
				echo '<div class="query">',htmlspecialchars($query_sql),'</div>';
				if ($conn->GetImage($query_sql)) {
					$filename = $conn->image_name;
					@unlink($filename);

					if ($handle = fopen($filename, "wb")) {
						// salva l'immagine
						$result = (fwrite($handle, $conn->image_data) !== FALSE);
						fclose($handle);
						if($result) {
							$info = getimagesize($filename);
							echo '<div class="info"><img src="'.$filename.'" '.$info[3].' border="0" alt=""></div>';
							echo '<div class="info">Nome file: <b>',$conn->image_name,'</b></div>';
						} else {
							echo '<div class="error">Impossibile scrivere nel file <b>'.$filename.'</b></div>';
						}
					} else {
						echo '<div class="error">Impossibile aprire il file <b>'.$filename.'</b></div>';
					}
				} else {
					echo '<div class="error">',$conn->last_errno,' ',$conn->last_errstr,'</div>';
				}
			} else if($_REQUEST["query_type"]=="attachment") {
				///////////////////////////////////////////////////////////////////
				// legge l'immagine
				///////////////////////////////////////////////////////////////////			
				echo '<div class="command">BRIDGE_CMD_GET_ATTACHMENT</div>';
				echo '<div class="query">',htmlspecialchars($query_sql),'</div>';
				if ($conn->GetAttachment($query_sql)) {
					$filename = $conn->attachment_name;
					@unlink($filename);

					if ($handle = fopen($filename, "wb")) {
						// salva l'immagine
						$result = (fwrite($handle, $conn->attachment_data) !== FALSE);
						fclose($handle);
						if($result) {
							$info = getimagesize($filename);
							echo '<pre class="info"><br />';
							echo 'Tipo        : <b>',$conn->attachment_type,'</b><br />';
							echo 'Codice      : <b>',$conn->attachment_id,'</b><br />';
							echo 'Descrizione : <b>',$conn->attachment_desc,'</b><br />';
							echo 'Numero riga : <b>',$conn->attachment_row,'</b><br />';
							echo 'Nome file   : <b>',$conn->attachment_name,'</b>';
							echo '</pre>';
							echo '<div class="info"><a href="',$filename,'">Scarica allegato: <b>',$filename,'</b></a></div>';
						} else {
							echo '<div class="error">Impossibile scrivere nel file <b>'.$filename.'</b></div>';
						}
					} else {
						echo '<div class="error">Impossibile aprire il file <b>'.$filename.'</b></div>';
					}
				} else {
					echo '<div class="error">',$conn->last_errno,' ',$conn->last_errstr,'</div>';
				}
			} else if($_REQUEST["query_type"]=="server_info") {
				///////////////////////////////////////////////////////////////////
				// informazioni server
				///////////////////////////////////////////////////////////////////
				echo '<div class="command">BRIDGE_CMD_SERVER_INFO</div>';
				echo '<div class="query">',htmlspecialchars($query_sql),'</div>';
				if ($info = $conn->ServerInfo($query_sql)) {
					echo '<pre class="info">';
					print_r($info);	
					echo '</pre>';
				} else {
					echo '<div class="error">',$conn->last_errno,' ',$conn->last_errstr,'</div>';
				}
			} else if($_REQUEST["query_type"]=="execute") {
				///////////////////////////////////////////////////////////////////
				// query di aggiornamento
				///////////////////////////////////////////////////////////////////
				echo '<div class="command">BRIDGE_CMD_EXECUTE</div>';
				echo '<div class="query">',htmlspecialchars($query_sql),'</div>';
				if ($conn->Execute($query_sql)) {
					echo '<div class="info">Eseguita correttamente.</div>';
				} else {
					echo '<div class="error">',$conn->last_errno,' ',$conn->last_errstr,'</div>';
				}
			} else if($_REQUEST["query_type"]=="query") {
				///////////////////////////////////////////////////////////////////
				// query di selezione
				///////////////////////////////////////////////////////////////////
				echo '<div class="command">BRIDGE_CMD_QUERY</div>';
				echo '<div class="query">',htmlspecialchars($query_sql),'</div>';
				if ($conn->Query($query_sql)) {
					echo '<table class="query_result" cellpadding="2" cellspacing="1">';
					echo '<tr>';
					foreach($conn->fields as $value) {
						echo '<th>',$value[1],'</th>';
					}
					echo '</tr>';
					flush();
					echo '<tbody>';
					while($row = $conn->FetchRow()) {
						// visualizza record
						echo '<tr>';
						foreach($row as $value) {
							echo '<td>',$value,'</td>';
						}
						// va a capo
						echo '</tr>';
						flush();
					}
					echo '</tbody>';
					echo '</table>';
					flush();
				} else {
					echo '<div class="error">',$conn->last_errno,' ',$conn->last_errstr,'</div>';
				}
			}
		} else {
			echo '<div class="error">',$conn->last_errno,' ',$conn->last_errstr,'</div>';
		}
		///////////////////////////////////////////////////////////////////
		// Chiude la connessione con il server
		///////////////////////////////////////////////////////////////////
		$conn->Close();
	} else {
		echo '<div class="error">Impossibile stabilire la connessione.</div>';
	}
}

set_time_limit(0);

// disabilita la chache del browser
$now=gmdate('D, d M Y H:i:s').' GMT';
header("Expires: $now");
header("Last-Modified: $now");
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">';
echo '<html>';
echo '<head>';
echo '<title>Console debug Elastico Bridge</title>';
echo '<style type="text/css">';
echo 'body,table {font-family: arial,sans-serif; font-size: 0.9em;}';
echo 'input,select,textarea {font-family: courier new,monospace; font-size: 0.9em;}';
echo 'div.info,pre.info {font-family: courier new,monospace; font-size: 0.9em; color: #009900; padding: 1px; margin: 0 0 0 8px;}';
echo 'div.error {font-family: courier new,monospace; font-size: 0.9em; color: #FF0000; padding: 1px; margin: 0 0 0 8px;}';
echo 'div.query {font-family: courier new,monospace; font-size: 0.9em; color: #0000CC; padding: 1px; margin: 0 0 0 8px;}';
echo 'div.command {font-family: courier new,monospace; font-size: 0.9em; font-weight: bold; padding: 1px; margin: 8px 0 0 0;}';
echo 'table.query_result {font-size: 0.8em; color: #0000CC; margin: 2px 0 0 8px; border: 1px solid black;}';
echo 'table.query_result th {background-color: #CCCCCC; text-align: left;}';
echo 'table.query_result td {background-color: #EFEFEF;}';
echo 'table.console {margin: 2px 0 2px 0; border: 1px solid black;}';
echo 'table.console th {background-color: #CCCCCC; text-align: left; vertical-align: top; padding: 3px 4px 0 2px;}';
echo 'table.console td {background-color: #EFEFEF;}';
echo 'table.console thead th {background-color: #CCCCCC; text-align: center; padding: 4px;}';
echo 'table.console tfoot th {background-color: #CCCCCC; text-align: center; padding: 4px;}';
echo '</style>';
echo '</head>';
echo '<body>';

// visualizza la form
showForm();

if($_REQUEST["posted"]) {
	// esegue la richiesta e visualizza il risultato
	doRequest();
}

echo '</body>';
echo '</html>';

?>